unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMOscope, MMCstDlg, MMDSPObj, MMWave, MMMemMap,
  MMSystem, MMPCMSup, MMUtils;

type
  TForm1 = class(TForm)
    MemMapFile: TMMMemMapFile;
    WaveFile: TMMWaveFile;
    OpenDialog: TMMWaveOpenDialog;
    Oscope: TMMOscope;
    btnLoad: TButton;
    procedure btnLoadClick(Sender: TObject);
  public
    procedure CreateWavePreview;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{==============================================================================}
procedure TForm1.CreateWavePreview;
var
   DataSize,Offset,BytesPerSeg: Longint;
   i,aWidth: integer;
   LeftMin,LeftMax,RightMin,RightMax,AbsMaxLeft,AbsMaxRight: Smallint;
   DataBuffer: array[0..1023] of Smallint;

begin
   aWidth := Oscope.BytesPerScope div  2;

   WaveFile.Wave.TimeFormat := tfByte;
   DataSize := WaveFile.Wave.DataSize;

   Offset := WaveFile.Wave.DataOffset;
   BytesPerSeg := ((DataSize div aWidth) div 4) * 4;

   MemMapFile.Active := True;

   FillChar(DataBuffer,sizeOf(DataBuffer),0);

   Oscope.Enabled := True;

   i := 0;
   while (i < aWidth) do
   begin
      if (i * BytesPerSeg) < DataSize then
      begin
         pcmFindMinMax(WaveFile.Wave.PWaveFormat,
                       PChar(MemMapFile.FileData) + Offset + (i * BytesPerSeg),
                       BytesPerSeg,
                       LeftMin, LeftMax, RightMin, RightMax);

         if (WaveFile.Wave.BitLength = 8) then
         begin
            LeftMin  := (LeftMin - 128) * 256;
            LeftMax  := (LeftMax - 128) * 256;
            RightMin := (RightMin - 128) * 256;
            RightMax := (RightMax - 128) * 256;
         end;
      end
      else
      begin
         LeftMin  := 0;
         LeftMax  := 0;
         RightMin := 0;
         RightMax := 0;
      end;

      if Abs(LeftMin) > Abs(LeftMax) then
         AbsMaxLeft := LeftMin
      else
         AbsMaxLeft := LeftMax;

      if Abs(RightMin) > Abs(RightMax) then
         AbsMaxRight := RightMin
      else
         AbsMaxRight := RightMax;

      if Abs(AbsMaxLeft) > Abs(AbsMaxRight) then
         DataBuffer[i] := AbsMaxLeft
      else
         DataBuffer[i] := AbsMaxRight;

      Oscope.RefreshPCMData(@DataBuffer);
      inc(i);
   end;
end;

{==============================================================================}
procedure TForm1.btnLoadClick(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
       Application.ProcessMessages;

       Oscope.ResetData;

       try
          MemMapFile.FileName := '';
          WaveFile.Wave.FileName := OpenDialog.FileName;
          if not WaveFile.Wave.Empty then
          begin
             if (WaveFile.Wave.FormatTag = WAVE_FORMAT_PCM) then
             begin
                MemMapFile.FileName := OpenDialog.FileName;
                CreateWavePreview;
             end
             else
             begin
                ShowMessage('Only PCM-Wave files can be loaded');
             end;
          end;

       except
          WaveFile.Wave.FreeWave;
          MemMapFile.Active := False;
          MemMapFile.FileName := '';
          Oscope.Enabled := False;
          ShowMessage('Error loading file');
       end;
   end;
end;

end.




